
Type TFixedLinearSpring Extends TController

	Field _body:TBody
	
	Field _bodyAttachPoint:Vector2 = Vector2.Zero()
	Field _worldAttachPoint:Vector2 = Vector2.Zero()
	
	Field _springConstant:Float
	Field _dampningConstant:Float
	Field _restLength:Float
	Field _breakPoint:Float = MathHelper.MaxValueF
	
	Field _springError:Float
	Field _difference:Vector2 = Vector2.Zero()
	
	'#Region Properties (setter/getter)
	Method GetBody:TBody()
		Return _body
	End Method
	
	Method SetBody(value:TBody)
		_body = value
	End Method
	
	Method GetSpringConstant:Float()
		Return _springConstant
	End Method
	
	Method SetSpringConstant(value:Float)
		_springConstant = value
	End Method
	
	Method GetDampningConstant:Float()
		Return _dampningConstant
	End Method
	
	Method SetDampningConstant(value:Float)
		_dampningConstant = value
	End Method
	
	Method GetBreakPoint:Float()
		Return _breakpoint
	End Method
	
	Method SetBreakPoint(value:Float)
		_breakpoint = value
	End Method
	
	Method GetSpringError:Float()
		Return _springError
	End Method
	
	Method GetBodyAttachPoint:Vector2()
		Return _bodyAttachpoint.Copy()
	End Method
	
	Method SetBodyAttachPoint(value:Vector2)
		_bodyAttachPoint.X = value.X
		_bodyAttachPoint.Y = value.Y
	End Method
	
	Method GetWorldAttachPoint:Vector2()
		Return _worldAttachPoint.Copy()
	End Method
	
	Method SetWorldAttachPoint(value:Vector2)
		_worldAttachPoint.X = value.X
		_worldAttachPoint.Y = value.Y
	End Method
	
	Method GetRestLength:Float()
		Return _restLength
	End Method
	
	Method SetRestLength(value:Float)
		_restLength = value
	End Method
	'#End Region 
	
	Function Create:TFixedLinearSpring(body:TBody, bodyAttachPoint:Vector2, worldAttachPoint:Vector2, springConstant:Float, dampningConstant:Float)
		Local spring:TFixedLinearSpring = New TFixedLinearSpring
		spring._body = body
		spring._bodyAttachPoint.X = bodyAttachPoint.X
		spring._bodyAttachPoint.Y = bodyAttachPoint.Y
		spring._worldAttachPoint.X = worldAttachPoint.X
		spring._worldAttachPoint.Y = worldAttachPoint.Y
		spring._springConstant = springConstant
		spring._dampningConstant = dampningConstant
		Vector2.SubtractVectorsref(worldAttachPoint, body.GetWorldPosition(bodyattachPoint), spring._difference)
		spring._restLength = spring._difference.Length()
		Return spring
	End Function
	
	'#Region Update variables
	Field _bodyWorldPoint:Vector2 = Vector2.Zero()
	Field _bodyVelocity:Vector2 = Vector2.Zero()
	Field _vectorTemp1:Vector2 = Vector2.Zero()
	Field _vectorTemp2:Vector2 = Vector2.Zero()
	Field _force:Vector2 = Vector2.Zero()
	Field _differenceNormalized:Vector2 = Vector2.Zero()
	Field _dampningForce:Float
	Field _springForce:Float
	Field _epsilon:Float =.00001
	Field _temp:Float
	'#End Region 
	Method Update(dt:Float)
		If Abs(_springError) > _breakPoint Then Return
		If _body.IsStatic() Then Return
		
		' calculate and apply spring force
		' F = -{s(L-r) + d[(v1-v2).L]/l}L/1 : s = spring const, d=dampning const, L=difference vector (p1-p2), l= difference magnitude, r= restlength
		_body.GetWorldPositionRef(_bodyAttachPoint, _bodyWorldPoint)
		Vector2.SubtractVectorsRef(_bodyWorldPoint, _worldAttachPoint, _difference)
		Local differenceMagnitude:Float = _difference.Length()
		If differenceMagnitude < _epsilon Then Return ' if already close to rest length then return
		
		'calculate spring force (kX)
		_springError = differenceMagnitude - _restLength
		Vector2.NormalizeRef(_difference, _differenceNormalized)
		_springForce = _springConstant * _springError 'kX
		
		'calculate relative velocity
		_body.GetVelocityAtLocalPointRef(_bodyAttachPoint, _bodyVelocity)
		
		' calculate dampning force (bV)
		_temp = Vector2.Dot(_bodyVelocity, _difference)
		_dampningForce = _dampningConstant * _temp / differenceMagnitude ' bV
		
		' calculate final force (spring+dampning)
		Vector2.ScaleRef(_differenceNormalized, - (_springForce + _dampningForce), _force)
		
		_body.ApplyForceAtLocalPoint(_force, _bodyAttachPoint)		
	End Method

End Type
